IF NOT OBJECT_ID('GET_PREVISAO_EXPIRAR_FIDELI') IS NULL
	BEGIN 
		DROP PROCEDURE GET_PREVISAO_EXPIRAR_FIDELI
	END

GO

CREATE PROCEDURE GET_PREVISAO_EXPIRAR_FIDELI(@CD_EMP INT, @CD_CLI INT)
AS
	BEGIN		
		
		DECLARE @RS_CD_EMP		INT
		DECLARE @RS_CD_CLI		INT
		DECLARE @RS_DT_CAD		DATETIME								
		DECLARE @RS_VLR_CRED	MONEY
		
		DECLARE @FLAG_MESES_EXPIRA_PONTOS_SEM_COMPRA INT
		DECLARE @FLAG_MESES_EXPIRA_PONTOS_POR_TEMPO  INT
		DECLARE @TEMPO_EXPIRA						INT
		DECLARE @VLR_EXPIRAR						MONEY
		DECLARE @DT_EXPIRA_COMPRA					DATETIME
		DECLARE @DT_EXPIRA_TEMPO					DATETIME
		DECLARE @DT_EXPIRA							DATETIME
		DECLARE @QTDE_PONTOS						MONEY
		DECLARE @DT_ULT_CP							DATETIME
		
		CREATE TABLE #RS_PONTOS_CRED   (CD_EMP				INT, 
										CD_CLI				INT, 
										DT_CAD				DATETIME, 
										DT_EXPIRA			DATETIME, 										
										QTDE_PONTOS			MONEY) 
		
		SET @FLAG_MESES_EXPIRA_PONTOS_SEM_COMPRA = (SELECT ABS(DBO.UFD_BUSCA_PARAM_SISTEMA(1,'FLAG_MESES_EXPIRA_PONTOS_SEM_COMPRA',0,0)))
		SET @FLAG_MESES_EXPIRA_PONTOS_POR_TEMPO  = (SELECT ABS(DBO.UFD_BUSCA_PARAM_SISTEMA(1,'FLAG_MESES_EXPIRA_PONTOS_POR_TEMPO',0,0)))
	  
		IF @FLAG_MESES_EXPIRA_PONTOS_SEM_COMPRA = 0 AND @FLAG_MESES_EXPIRA_PONTOS_POR_TEMPO = 0 
			BEGIN
				RETURN
			END
		
		IF @FLAG_MESES_EXPIRA_PONTOS_SEM_COMPRA > 0 	
			BEGIN
				--Verificando o tipo de expiracao prevista para os pontos. Expiracao por tempo sem compra
				SET @DT_ULT_CP = ISNULL((SELECT MAX(CRED.DT_CAD) 
										FROM RC_CLI_FIDELI_PONTOS_CREDITO CRED	
											INNER JOIN RC_MOTIVO_PONTO ON 
												CRED.CD_MT_PONTO = RC_MOTIVO_PONTO.CD_MT_PONTO
										WHERE CRED.CD_EMP 		= @CD_EMP
											  AND CRED.CD_CLI 	= @CD_CLI
											  AND RC_MOTIVO_PONTO.CD_ACAO_MT_PONTO = 0), DATEADD(MONTH, @FLAG_MESES_EXPIRA_PONTOS_SEM_COMPRA * -1, GETDATE())) 									  
				
				
			END			


		SET @VLR_EXPIRAR  = ISNULL((SELECT QTDE_PONTOS 
									FROM RC_CLI 
									WHERE 
										CD_EMP 		= @CD_EMP
										AND CD_CLI 	= @CD_CLI),0)

		IF @VLR_EXPIRAR > 0
			BEGIN
				DECLARE RS_RESULT CURSOR FOR
					SELECT CRED.CD_EMP, CRED.CD_CLI, CRED.DT_CAD, SUM(CRED.QTDE_PONTOS) AS VLR_CRED
					FROM RC_CLI_FIDELI_PONTOS_CREDITO CRED
					WHERE 
						CRED.CD_EMP 		= @CD_EMP
						AND CRED.CD_CLI 	= @CD_CLI		
						AND CRED.QTDE_PONTOS > 0					
					GROUP BY CRED.CD_EMP, CRED.CD_CLI, CRED.DT_CAD			
					ORDER BY 
						CRED.DT_CAD DESC
				
				
					--Abrindo cursor
					OPEN RS_RESULT
					
					--Atribuindo valores do select nas variveis
					FETCH NEXT FROM RS_RESULT INTO  @RS_CD_EMP, 
													@RS_CD_CLI, 
													@RS_DT_CAD,									
													@RS_VLR_CRED
													
					--Iniciando lao
					WHILE @@FETCH_STATUS = 0 AND @VLR_EXPIRAR > 0
						BEGIN								
							
							IF @VLR_EXPIRAR > @RS_VLR_CRED
								BEGIN
									SET @QTDE_PONTOS 		= @RS_VLR_CRED
									SET @VLR_EXPIRAR 		= (@VLR_EXPIRAR - @RS_VLR_CRED)
								END
							ELSE	
								BEGIN
									SET @QTDE_PONTOS 		= @VLR_EXPIRAR
									SET @VLR_EXPIRAR		= 0
								END 
							
							SET @DT_EXPIRA_COMPRA	= DATEADD(MONTH, @FLAG_MESES_EXPIRA_PONTOS_SEM_COMPRA, @DT_ULT_CP)
							SET @DT_EXPIRA_TEMPO	= DATEADD(MONTH, @FLAG_MESES_EXPIRA_PONTOS_POR_TEMPO, @RS_DT_CAD)							

							SET @DT_EXPIRA			= (CASE WHEN @DT_EXPIRA_COMPRA < @DT_EXPIRA_TEMPO THEN @DT_EXPIRA_COMPRA ELSE @DT_EXPIRA_TEMPO END)
																	
							INSERT INTO #RS_PONTOS_CRED (CD_EMP, CD_CLI, DT_CAD, DT_EXPIRA, QTDE_PONTOS) 
												 VALUES (@RS_CD_EMP, @RS_CD_CLI, @RS_DT_CAD, @DT_EXPIRA, @QTDE_PONTOS)
							
							IF @VLR_EXPIRAR = 0 
								BEGIN
									BREAK
								END
																		
							--Atribuindo valores do select nas variveis
							FETCH NEXT FROM RS_RESULT INTO  @RS_CD_EMP, 
															@RS_CD_CLI, 
															@RS_DT_CAD,									
															@RS_VLR_CRED
						END

					CLOSE RS_RESULT
					DEALLOCATE RS_RESULT

			END				

		SELECT 
			(CASE WHEN DT_EXPIRA BETWEEN GETDATE() AND DATEADD(DAY,60, GETDATE())	THEN 60
				  WHEN DT_EXPIRA BETWEEN GETDATE() AND DATEADD(DAY,90, GETDATE())	THEN 90
				  WHEN DT_EXPIRA BETWEEN GETDATE() AND DATEADD(DAY,120, GETDATE())	THEN 120
			 ELSE '' END) AS DIAS_EXPIRA,				
			SUM(QTDE_PONTOS) AS QTDE_PONTOS
		FROM #RS_PONTOS_CRED
		WHERE 
			DT_EXPIRA BETWEEN GETDATE()	AND DATEADD(DAY,120, GETDATE())
		GROUP BY 
			(CASE WHEN DT_EXPIRA BETWEEN GETDATE() AND DATEADD(DAY,60, GETDATE())	THEN 60
				  WHEN DT_EXPIRA BETWEEN GETDATE() AND DATEADD(DAY,90, GETDATE())	THEN 90
				  WHEN DT_EXPIRA BETWEEN GETDATE() AND DATEADD(DAY,120, GETDATE())	THEN 120
			 ELSE '' END)
				

	END				 